VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmMain 
   Caption         =   "AdoUpd"
   ClientHeight    =   4710
   ClientLeft      =   60
   ClientTop       =   405
   ClientWidth     =   6960
   LinkTopic       =   "Form1"
   ScaleHeight     =   4710
   ScaleWidth      =   6960
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame FrameConnect 
      Caption         =   "Connect"
      Height          =   1215
      Left            =   240
      TabIndex        =   5
      Top             =   120
      Width           =   6375
      Begin VB.TextBox txtConnect 
         Height          =   375
         Left            =   240
         TabIndex        =   7
         Top             =   600
         Width           =   4335
      End
      Begin VB.CommandButton cmdConnect 
         Caption         =   "Con&nect"
         Height          =   375
         Left            =   4680
         TabIndex        =   6
         Top             =   600
         Width           =   1455
      End
      Begin VB.Label lblConnect 
         Caption         =   "Database name"
         Height          =   255
         Left            =   240
         TabIndex        =   8
         Top             =   360
         Width           =   2415
      End
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   495
      Left            =   4680
      TabIndex        =   1
      Top             =   4080
      Width           =   1935
   End
   Begin VB.Frame FrameStatus 
      Height          =   2295
      Left            =   240
      TabIndex        =   0
      Top             =   1560
      Width           =   6375
      Begin VB.CommandButton cmdStart 
         Caption         =   "S&tart"
         Height          =   495
         Left            =   240
         TabIndex        =   4
         Top             =   1680
         Width           =   5895
      End
      Begin VB.TextBox txtStatus 
         BackColor       =   &H80000018&
         Height          =   375
         Left            =   240
         TabIndex        =   3
         Top             =   960
         Width           =   5895
      End
      Begin MSComctlLib.ProgressBar pbProgress 
         Height          =   495
         Left            =   240
         TabIndex        =   2
         Top             =   360
         Width           =   5895
         _ExtentX        =   10398
         _ExtentY        =   873
         _Version        =   393216
         Appearance      =   1
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' This example illustrates how to use ADO over MyOLEDB Provider
' to update data in the the Btrieve table.
' This example works with "Sample2" table from _db sample database included
' to Btrieve provider package.
' Application updates first ulMaxNumOfRows rows from the table in the following way:
' Field ID increases by 10.
' Field LastName transforms to UPPER case
'
Option Explicit

' connection string
Private sCS As String '  "Path to Data Dictionary"

' rows to delete
Private Const ulMaxNumOfRows = 10

' num of deleted rows
Private ulNumOfRows As Long

Private cnn As ADODB.Connection
Private rs As ADODB.Recordset

Function Connect() As Boolean
Dim i As Long

On Error GoTo Connect_Error

' set variables
Set cnn = New ADODB.Connection

' Open Connection
cnn.Provider = "MySqlProv"
cnn.ConnectionString = sCS
cnn.CommandTimeout = 10000
cnn.ConnectionTimeout = 10000
cnn.CursorLocation = adUseServer
cnn.Open

' quit
    Connect = True
Connect_Exit:
    Exit Function

Connect_Error:
    If sCS <> "" Then
        MsgBox ("Something wrong happened during connection: " & Err.Description)
    End If
    Connect = False
    Resume Connect_Exit
End Function

Function Update() As Boolean
Dim bStatus As Boolean
Dim i As Long

On Error GoTo Update_Error

' set variables
Set rs = New ADODB.Recordset

' Open Recordset
rs.CacheSize = 100
rs.Open "Sample2", cnn, adOpenKeyset, adLockOptimistic, adCmdTableDirect

' update status
bStatus = UpdateTextStatus("You are about to update " & CStr(ulMaxNumOfRows) & " rows.")
bStatus = UpdateProgressBarStatus(0)

' to first record
rs.MoveFirst
ulNumOfRows = 0
For i = 1 To ulMaxNumOfRows
    ' Check whether end of table is reached
    If rs.BOF Or rs.EOF Then Exit For
    
    ' Update current record
    rs!ID = rs!ID + 10
    rs!LastName = UCase(rs!LastName)
    rs.Update
       
    ' to next record
    rs.MoveNext
    ulNumOfRows = ulNumOfRows + 1
    
    ' update status
    bStatus = UpdateTextStatus(CStr(ulMaxNumOfRows) & " rows were updated.")
    bStatus = UpdateProgressBarStatus((CDbl(i) / CDbl(ulMaxNumOfRows)) * 100)
Next i

' show number of deleted row & update status
bStatus = UpdateTextStatus(CStr(i - 1) & " rows were updated.")
bStatus = UpdateProgressBarStatus(100)

' quit
Update_Exit:
    ' disable controls
    Me.pbProgress.Enabled = False
    Me.txtStatus.Enabled = False
    Me.cmdStart.Enabled = False
    
    ' close connection
    If cnn.State <> adStateClosed Then
        cnn.Close
    End If
    
    ' close recordset
    If rs.State <> adStateClosed Then
        rs.Close
    End If
    
    ' clear variables
    Set cnn = Nothing
    Set rs = Nothing
    Exit Function

Update_Error:
    MsgBox ("Something wrong happened: " & Err.Description)
    Resume Update_Exit
End Function

Function UpdateTextStatus(s As String) As Boolean
    Me.txtStatus.Text = s
    UpdateTextStatus = True
End Function

Function UpdateProgressBarStatus(d As Double) As Boolean
    Me.pbProgress.Value = CInt(d)
    UpdateProgressBarStatus = True
End Function

Private Sub cmdConnect_Click()
    sCS = Me.txtConnect
    
    If (Connect()) Then
        ' enable controls
        Me.pbProgress.Enabled = True
        Me.txtStatus.Enabled = True
        Me.cmdStart.Enabled = True
        ' banner
        Me.txtStatus.Text = "You are about to update first " & CStr(ulMaxNumOfRows) & " rows."
    Else
        MsgBox ("Not connected! " & Err.Description)
    End If
End Sub

Private Sub cmdExit_Click()
    ' leave application
    End
End Sub

Private Sub cmdLocation_Click()
    frmLocation.Show 1
    
    ' What was the user's choice ?
    If (bCancel = False) Then
        txtConnect.Text = sDDFPath
    End If
End Sub

Private Sub cmdStart_Click()
    Dim bStatus As Boolean
    bStatus = Update()
End Sub

Private Sub Form_Load()
        ' disable controls
        Me.pbProgress.Enabled = False
        Me.txtStatus.Enabled = False
        Me.cmdStart.Enabled = False
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    ' clear variables
    Set cnn = Nothing
    Set rs = Nothing
End Sub

